# tril {#tril}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`tril(X, [k=0])`

## Arguments {#arguments}

**X** is a matrix.

**k** \(optional\) is an integer.

## Details {#details}

If *k* is not specified: return the lower triangular portion of matrix *X*.

If *k* is specified: return the elements on and below the k-th diagonal of *X*.

## Examples {#examples}

```
m=matrix(1 2 3, 4 5 6, 7 8 9);
m;
```

|col1|col2|col3|
|----|----|----|
|1|4|7|
|2|5|8|
|3|6|9|

```
tril(m);
```

|col1|col2|col3|
|----|----|----|
|1|0|0|
|2|5|0|
|3|6|9|

```
tril(m,1);
```

|col1|col2|col3|
|----|----|----|
|1|4|0|
|2|5|8|
|3|6|9|

```
tril(m,-1);
```

|col1|col2|col3|
|----|----|----|
|0|0|0|
|2|0|0|
|3|6|0|

Related function: [triu](triu.md)

