# triggerTSDBCompaction {#triggertsdbcompaction}

## Syntax {#syntax}

`triggerTSDBCompaction(chunkId, [level=0])`

## Arguments {#arguments}

**chunkId** is a STRING scalar indicating the chunk ID.

**level** \(optional\) specifies at which level the compaction is triggered. It can be an integer in \[-1,3\].

-   If *level* is an integer in \[0,3\], compaction is triggered at the specified level. The default value is 0.
-   When *level* = -1, all level files are compacted into a single level file.

## Details {#details}

Use this command to manually trigger the compaction of TSDB level files at specific level for optimal reading performance.

**Note**: The compaction of level 3 files can only be performed when configuration parameter *allowTSDBLevel3Compaction* is set to true and for tables with *keepDuplicates*=FIRST/LAST specified.

## Examples {#examples}

There are 2 file types in a chunk, the file chunk containing information about the database and table schema, and the tablet chunk storing data. Compaction of level files can only be conducted within a tablet chunk. Set "type=1" to filter the IDs of tablet chunks.

```
chunkIds = exec chunkId from getChunksMeta() where type=1
for (x in chunkIds) {
    triggerTSDBCompaction(x)
}
```

