# transFreq {#transfreq}

## Syntax {#syntax}

`transFreq(X, rule, [closed], [label], [origin='start_day'])`

## Arguments {#arguments}

**X** is a scalar/vector of temporal type.

**rule** is a string that can take the following values:

|Values of parameter "rule"|Corresponding DolphinDB function|
|--------------------------|--------------------------------|
|"B"|businessDay|
|"W"|weekEnd|
|"WOM"|weekOfMonth|
|"LWOM"|lastWeekOfMonth|
|"M"|monthEnd|
|"MS"|monthBegin|
|"BM"|businessMonthEnd|
|"BMS"|businessMonthBegin|
|"SM"|semiMonthEnd|
|"SMS"|semiMonthBegin|
|"Q"|quarterEnd|
|"QS"|quarterBegin|
|"BQ"|businessQuarterEnd|
|"BQS"|businessQuarterBegin|
|"A"|yearEnd|
|"AS"|yearBegin|
|"BA"|businessYearEnd|
|"BAS"|businessYearBegin|
|"D"|date|
|"H"|hourOfDay|
|"min"|minuteOfHour|
|"S"|secondOfMinute|
|"L"|millisecond|
|"U"|microsecond|
|"N"|nanosecond|
|"SA"|semiannualEnd|
|"SAS"|semiannualBegin|

The strings above can also be used with positive integers for parameter *rule*. For example, "2M" means the end of every two months. In addition, *rule* can also be set as the identifier of the trading calendar, e.g., the Market Identifier Code of an exchange, or a user-defined calendar name. Positive integers can also be used with identifiers. For example, "2XNYS" means every two trading days of New York Stock Exchange.

**closed** \(optional\) is a string indicating which boundary of the interval is closed.

-   The default value is 'left' for all values of *rule* except for 'M', 'A', 'Q', 'BM', 'BA', 'BQ', and 'W' which all have a default of 'right'.

-   The default is 'right' if *origin* is 'end' or 'end\_day'.


**label** \(optional\) is a string indicating which boundary is used to label the interval.

-   The default value is 'left' for all values of *rule* except for 'M', 'A', 'Q', 'BM', 'BA', 'BQ', and 'W' which all have a default of 'right'.

-   The default is 'right' if *origin* is 'end' or 'end\_day'.


**origin** \(optional\) is a string or a scalar of the same data type as *X*, indicating the timestamp where the intervals start. It can be 'epoch', start', 'start\_day', 'end', 'end\_day' or a user-defined time object. The default value is 'start\_day'.

-   'epoch': *origin* is 1970-01-01

-   'start': *origin* is the first value of the timeseries

-   'start\_day': *origin* is 00:00 of the first day of the timeseries

-   'end': *origin* is the last value of the timeseries

-   'end\_day': *origin* is 24:00 of the last day of the timeseries


## Details {#details}

For each element of *X*, conduct a transformation as specified with parameter *rule*. The result has the same length as *X*.

## Examples {#examples}

```
transFreq(2020.11.08 2020.11.09 2020.11.18, "SM");
// output: [2020.10.31,2020.10.31,2020.11.15]

transFreq(2020.08.08 2020.11.18, "Q");
// output: [2020.09.30,2020.12.31]

transFreq(2020.08.08 2020.11.18, "2Q");
// output: [2020.09.30,2021.03.31]
```

```
s = temporalAdd(2022.01.01 00:00:00,1..8,`m);

s.transFreq(rule="3min");
// output: [2022.01.01T00:00:00,2022.01.01T00:00:00,2022.01.01T00:03:00,2022.01.01T00:03:00,2022.01.01T00:03:00,2022.01.01T00:06:00,2022.01.01T00:06:00,2022.01.01T00:06:00]

s.transFreq(rule=`3min,closed=`right);
// output: [2022.01.01T00:00:00,2022.01.01T00:00:00,2022.01.01T00:00:00,2022.01.01T00:03:00,2022.01.01T00:03:00,2022.01.01T00:03:00,2022.01.01T00:06:00,2022.01.01T00:06:00]

s.transFreq(rule=`3min,closed=`right,origin=`end);
// output: [2021.12.31T23:59:00,2021.12.31T23:59:00,2022.01.01T00:02:00,2022.01.01T00:02:00,2022.01.01T00:02:00,2022.01.01T00:05:00,2022.01.01T00:05:00,2022.01.01T00:05:00]
```

