# toStdJson {#tostdjson}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`toStdJson(obj)`

## Arguments {#arguments}

**obj** cannot be of data form matrix or pair, nor can it be of data type UUID, IPADDR, INT128, COMPRESSED, or system types.

## Details {#details}

Convert a DolphinDB object to JSON format.

## Examples {#examples}

```
x=1 2 3
toStdJson(x);
// output: [1, 2, 3]

t=table(1 2 3 as id, 10 20 30 as val)
toStdJson(t);
// output: [{"id": 1,"val": 10},{"id": 2,"val": 20},{"id": 3,"val": 30}]

b = set(2012.06.13T13:30:10 2017.07.10T14:10:12)
toStdJson(b);
// output: ["2017.07.10 14:10:12","2012.06.13 13:30:10"]

b = dict(int,datetime)
b[0] = 2012.06.13 13:30:10
b[1] = 2017.07.10 14:10:12
toStdJson(b);
// output: {"1": "2017.07.10 14:10:12","0": "2012.06.13 13:30:10"}

t1=table(`x`y`z as b, 2012.06.13 13:30:10 2012.06.13 13:30:10 2012.06.13 13:30:10 as c,10.8 7.6 3.5 as F)
toStdJson(t1);
// output: [{"b": "x","c": "2012.06.13 13:30:10","F": 10.8},{"b": "y","c": "2012.06.13 13:30:10","F": 7.6},{"b": "z","c": "2012.06.13 13:30:10","F": 3.5}]
```

Related function: [toJson](toJson.md)

