# toCharArray {#tochararray}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`toCharArray(X)`

## Arguments {#arguments}

**X** a scalar/vector of the STRING/BLOB/SYMBOL data type.

## Details {#details}

Split a string into a vector of the CHAR data type.

-   If *X* is a scalar, return a vector.

-   If *X* is a vector, return an array vector.


## Examples {#examples}

```
str = "It is great!\n"
print str.toCharArray()
// output: ['I','t',' ','i','s',' ','g','r','e','a','t','!',10]

str1 = ["A#", "B C", "D\t"]
print str1.toCharArray()
// output: [['A','#'],['B',' ','C'],['D',9]]
```

```
// Compress a vector and save it in a binary file
x=1..100
// A string of BLOB type uses the first 4 bytes to identify its length
y=blob(compress(x).concat())
dir = WORK_DIR+"/toCharArray.bin"
g = file(dir, "w")
// Use toCharArray to convert a string of BLOB type, only the correct data will be written to the file (except for the header)
g.write(y.toCharArray())   // 467 bytes were written
g.close()

/* output:
dir1 = WORK_DIR+"/toCharArray1.bin"
g1 = file(dir1, "w")
g1.write(y)    // 471 bytes were written
g1.close()
*/
```

Related Functions: [split](../s/split.md)

