# toArray {#toArray}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`toArray(X)`

## Arguments {#arguments}

**X** is a column name or an expression on column\(s\).

## Details {#details}

Use with [GROUP BY](../../Programming/SQLStatements/groupby.md) to aggregate grouped data into an [array vector](../../Programming/DataTypesandStructures/DataForms/Vector/arrayVector.md).

## Examples {#examples}

``` {#codeblock_zq1_tms_c2c}
t = table(1 1 3 4 as id, 1 3 5 6 as v1)
new_t = select toArray(v1) as newV1 from t group by id
/* 
id newV1
-- -----
1  [1,3]
3  [5]  
4  [6]  
*/


new_t = select toArray(v1+1) as newV1 from t group by id
/* 
id newV1
-- -----
1  [2,4]
3  [6]  
4  [7]  
*/
```

