# tmwsumTopN {#tmwsumtopn}

## Syntax {#syntax}

`tmwsumTopN(T, X, Y, S, window, top, [ascending=true], [tiesMethod='latest'])`

Please see [tmTopN](../Themes/tmTopN.md) for the parameters and windowing logic.

## Details {#details}

Within a sliding window of given length \(measured by time\), the function stably sorts *X* and *Y* by *S* in the order specified by *ascending*, then calculates the moving sums of *X* with *Y* as weights.

**Return value**: a vector of DOUBLE type

## Examples {#examples}

```
T=2023.01.03+1..7
X = [2, 1, 4, 3, 4, 3, 1]
Y=[1, 7, 8, 9, 0, 5, 8]
S = [5, 8, 1, , 1, 1, 3]
// The null values in S are ignored in data sorting, and the corresponding elements in X and Y do not participate in calculation
tmwsumTopN(T,X,Y,S,6,4)
// output: [2,9,41,41,41,49,55]

T=2023.01.03 2023.01.07 2023.01.08 2023.01.10 2023.01.11 2023.01.12
X=8 3 1 2 5 2
Y=1 7 8 9 0 5
S=1 5 2 3 1 1
t=table(T as time, X as val1, Y as val2, S as id)
select tmwsumTopN(time,val1,val2,id,4,3) as topN from t
```

|topN|
|----|
|8|
|21|
|29|
|47|
|26|
|28|

Related function: [tmwsum](tmwsum.md)

