# tmwsum {#tmwsum}

## Syntax {#syntax}

`tmwsum(T, X, Y, window)`

Please see [tmFunctions](../Themes/tmFunctions.md) for the parameters and windowing logic.

## Details {#details}

Calculate the moving sum of *X* with *Y* as weights in a sliding window.

The weights in a sliding window are automatically adjusted so that the sum of weights for all non-null elements in the sliding window is 1.

## Example {#example}

```
T = 1 1 1 1 2 5 6 8 9 10
X = 1..10
Y = double(1..10)\10
m = table(T as t,X as x, Y as y)
select *, tmwsum(t, y, x, 3) from m
```

|t|x|y|tmwsum\_t|
|---|---|---|---------|
|1|1|0.1|0.1|
|1|2|0.2|0.5|
|1|3|0.3|1.4|
|1|4|0.4|3|
|2|5|0.5|5.5|
|5|6|0.6|3.6|
|6|7|0.7|8.5|
|8|8|0.8|11.3|
|9|9|0.9|14.5|
|10|10|1|24.5|

```
T = 2021.01.02 2021.01.06 join 2021.01.07..2021.01.14
X = 1..10
Y = double(1..10)\10
m=table(T as t,X as x, Y as y)
select *, tmwsum(t, y, x, 3) from m
```

|t|x|y|tmwsum\_t|
|---|---|---|---------|
|2021.01.02|1|0.1|0.1|
|2021.01.06|2|0.2|0.4|
|2021.01.07|3|0.3|1.3|
|2021.01.08|4|0.4|2.9|
|2021.01.09|5|0.5|5|
|2021.01.10|6|0.6|7.7|
|2021.01.11|7|0.7|11|
|2021.01.12|8|0.8|14.9|
|2021.01.13|9|0.9|19.4|
|2021.01.14|10|1|24.5|

```
select *, tmwsum(t, y, x, 1w) from m
```

|t|x|y|tmwsum\_t|
|---|---|---|---------|
|2021.01.02|1|0.1|0.1|
|2021.01.06|2|0.2|0.5|
|2021.01.07|3|0.3|1.4|
|2021.01.08|4|0.4|3|
|2021.01.09|5|0.5|5.4|
|2021.01.10|6|0.6|9|
|2021.01.11|7|0.7|13.9|
|2021.01.12|8|0.8|20.3|
|2021.01.13|9|0.9|28|
|2021.01.14|10|1|37.1|

Related functions: [wsum](../w/wsum.md), [mwsum](../m/mwsum.md)

