# tmvarp {#tmvarp}

## Syntax {#syntax}

`tmvarp(T, X, window)`

Please see [tmFunctions](../Themes/tmFunctions.md) for the parameters and windowing logic.

## Details {#details}

Calculate the moving population variance of *X* in a sliding window.

## Examples {#examples}

```
T = 1 1 3 5 8 15 15 20
X = 5 2 4 1 2 8 9 10
m=table(T as t, X as x)
select *, tmvarp(t, x, 3) from m
```

|t|x|tmvarp\_t|
|---|---|---------|
|1|5|0|
|1|2|2.25|
|3|4|1.5556|
|5|1|2.25|
|8|2|0|
|15|8|0|
|15|9|0.25|
|20|10|0|

```
T = 2021.01.02 2021.01.02  2021.01.04  2021.01.05 2021.01.07 2021.01.08
X = NULL 4 NULL -1 2 4
m = table(T as t,X as x)
select *, tmvarp(t, x, 3d) from m
```

|t|x|tmvarp\_t|
|---|---|---------|
|2021.01.02|||
|2021.01.02|4|0|
|2021.01.04||0|
|2021.01.05|-1|0|
|2021.01.07|2|2.25|
|2021.01.08|4|1|

```
select *, tmvarp(t, x, 1w) from m
```

|t|x|tmvarp\_t|
|---|---|---------|
|2021.01.02|||
|2021.01.02|4|0|
|2021.01.04||0|
|2021.01.05|-1|6.25|
|2021.01.07|2|4.2222|
|2021.01.08|4|4.1875|

Related Functions: [mvarp](../m/mvarp.md), [varp](../v/varp.md)

