# tmpercentile {#tmpercentile}

## Syntax {#syntax}

`tmpercentile(T, X, percent, window, [interpolation='linear'])`

Please see [tmFunctions](../Themes/tmFunctions.md) for the common parameters and windowing logic.

## Parameters {#parameters}

**percent** is an integer or floating number between 0 and 100.

**interpolation** \(optional\) is a string indicating the interpolation method to use if the specified percentile is between two elements in *X* \(assuming the i-th and \(i+1\)-th element in the sorted *X*\) . It can take the following values:

-   'linear': ![](../../images/tmlinear.png) where ![](../../images/tmfraction.png)

-   'lower': ![](../../images/xi.png)

-   'higher': ![](../../images/higher.png)

-   'nearest': ![](../../images/xi.png) or ![](../../images/higher.png) that is closest to the specified percentile

-   'midpoint': ![](../../images/midpoint.png)


The default value of *interpolation* is 'linear'.

## Details {#details}

Return the percentile rank of each element of *X* in a sliding window.

## Examples {#examples}

```
T = 1 1 1 2 5 6
X = 1 4 NULL -1 NULL 4
m = table(T as t,X as x)
select *, tmpercentile(t, x, 50, 3) from m
```

|t|x|tmpercentile\_t|
|---|---|---------------|
|1|1|1|
|1|4|2.5|
|1||2.5|
|2|-1|1|
|5|||
|6|4|4|

```
T = 2021.01.02 2021.01.02  2021.01.04  2021.01.05 2021.01.07 2021.01.08
X = NULL 4 NULL -1 2 4
m = table(T as t,X as x)
select *, tmpercentile(t, x, 50, 3d) from m
```

|t|x|tmpercentile\_t|
|---|---|---------------|
|2021.01.02|||
|2021.01.02|4|4|
|2021.01.04||4|
|2021.01.05|-1|-1|
|2021.01.07|2|0.5|
|2021.01.08|4|3|

```
select *, tmpercentile(t, x, 50, 1w) from m
```

|t|x|tmpercentile\_t|
|---|---|---------------|
|2021.01.02|||
|2021.01.02|4|4|
|2021.01.04||4|
|2021.01.05|-1|1.5|
|2021.01.07|2|2|
|2021.01.08|4|3|

Related Functions: [percentile](../p/percentile.md), [mpercentile](../m/mpercentile.md)

