# tmovingWindowData {#tmovingwindowdata}

## Syntax {#section_spg_ftv_bzb .section}

`tmovingWindowData(T, X, window, [leftClosed=false])`

## Arguments {#section_xzw_ftv_bzb .section}

**T** is a non-strictly increasing vector of integral or temporal type.

**X** is a vector of the same size as *T*.

**window** is a positive integer or a DURATION value indicating the size of a time-based window.

**leftClosed** \(optional\) is a Boolean indicating whether the left boundary of window is included. The default value is false.

## Details {#section_wdp_gtv_bzb .section}

Return an array vector where each row indicates the elements of a window sliding over *X*.

## Examples {#section_pk2_htv_bzb .section}

``` {#codeblock_tht_htv_bzb}
T = 2022.01.01T09:00:00 + 1 1 2 3 6 7 9 10 13 14
S = 1..10
tmovingWindowData(T, S, 3s)
// output: [[1],[1,2],[1,2,3],[1,2,3,4],[5],[5,6],[6,7],[7,8],[9],[9,10]]

tmovingWindowData(T, S, 3s, leftClosed=true)
// output: [[1],[1,2],[1,2,3],[1,2,3,4],[4,5],[5,6],[5,6,7],[6,7,8],[8,9],[9,10]]

// output the calculation result of metrics with a 10-minute sliding window in the reactive state engine
n = 100
DateTime = 2023.01.01T09:00:00 + rand(10000, n).sort!()
SecurityID = take(`600021`600022`600023`600024`600025, n)
Price = 1.0 + rand(1.0, n) 
t = table(1:0, `DateTime`SecurityID`Price, [TIMESTAMP, SYMBOL, DOUBLE])
tableInsert(t, DateTime, SecurityID, Price)
output = table(100:0, `SecurityID`DateTime`PriceNew, [SYMBOL, DATETIME, DOUBLE[]])

engine = createReactiveStateEngine(name="rseEngine", metrics=[<DateTime>, <tmovingWindowData(DateTime, Price,10m)>], dummyTable=t, outputTable=output, keyColumn=`SecurityID, keepOrder=true)
engine.append!(t)
dropStreamEngine(`rseEngine)
```

**Parent topic:**[Functions](../../Functions/category.md)

