# tmove {#tmove}

## Syntax {#syntax}

`tmove(T, X, window)`

## Arguments {#arguments}

**T** is a non-strictly increasing vector of temporal or integral type. It cannot contain null values.

**X** is a vector with the same length as *T*.

**window** is a positive integer or DURATION type.

## Details {#details}

For each element *T i* in *T*, return the element in *X* which is at the same position as \(*T i-window*\) in *T*. If there is no match of \(*T i - window*\) in *T*, return the corresponding element in *X* at the previous adjacent time of \(*Ti - window*\).

## Examples {#examples}

```
T = 1 1 1 2 5 6
X = 1 4 NULL -1 NULL 4
m = table(T as t,X as x)
select *, tmove(t, x, 3) from m
```

|t|x|tmove\_t|
|---|---|--------|
|1|1||
|1|4||
|1|||
|2|-1||
|5||-1|
|6|4|-1|

```
T = 2021.01.02 2021.01.02  2021.01.04  2021.01.05 2021.01.07 2021.01.09
X = 5 4 NULL -1 2 4
m = table(T as t,X as x)
select *, tmove(t, x, 3d) from m
```

|t|x|tmove\_t|
|---|---|--------|
|2021.01.02|5||
|2021.01.02|4||
|2021.01.04|||
|2021.01.05|-1|4|
|2021.01.07|2||
|2021.01.09|4|-1|

```
select *, tmove(t, x, 1w) from m
```

|t|x|tmove\_t|
|---|---|--------|
|2021.01.02|5||
|2021.01.02|4||
|2021.01.04|||
|2021.01.05|-1||
|2021.01.07|2||
|2021.01.09|4|4|

Related function: [move](../m/move.md)

