# tmavg {#tmavg}

## Syntax {#syntax}

`tmavg(T, X, window)`

Please see [tmFunctions](../Themes/tmFunctions.md) for the parameters and windowing logic.

## Details {#details}

Calculate the moving average of *X* in a sliding window.

## Examples {#examples}

```
T = 1 1 1 2 5 6
X = 1 4 2 -1 2 4
m = table(T as t,X as x)
select *, tmavg(t, x, 3) from m
```

|t|x|tmavg\_t|
|---|---|--------|
|1|1|1|
|1|4|2.5|
|1|2|2.3333|
|2|-1|1.5|
|5|2|2|
|6|4|3|

```
T = 2021.01.02 2021.01.02  2021.01.04  2021.01.05 2021.01.07 2021.01.08
X = 1 4 2 -1 2 4
m = table(T as t,X as x)
select *, tmavg(t, x, 3d) from m
```

|t|x|tmavg\_t|
|---|---|--------|
|2021.01.02|1|1|
|2021.01.02|4|2.5|
|2021.01.04|2|2.3333|
|2021.01.05|-1|0.5|
|2021.01.07|2|0.5|
|2021.01.08|4|3|

```
select *, tmavg(t, x, 1w) from m
```

|t|x|tmavg\_t|
|---|---|--------|
|2021.01.02|1|1|
|2021.01.02|4|2.5|
|2021.01.04|2|2.3333|
|2021.01.05|-1|1.5|
|2021.01.07|2|1.6|
|2021.01.08|4|2|

Related functions: [mavg](../m/mavg.md), [avg](../a/avg.md)

