# tmTopRange {#tmTopRange}

## Syntax {#Syntax .section}

`tmTopRange(T, X, window)`

Please see [tmFunctions](../Themes/tmFunctions.md) for the parameters and windowing logic.

## Details {#Details .section}

For each element *Xi* in a sliding window of *X*, count the continuous nearest neighbors to its left that are smaller than *Xi*. Null values are treated as the minimum values.

## Examples {#Examples .section}

``` {#codeblock_zqc_dcd_jbc}
t = [0, 1, 2, 3, 7, 8, 9, 10, 11]
x = [NULL, 3.1, NULL, 3.0, 2.9, 2.8, 3.1, NULL, 3.2];
tmTopRange(t, x, window=3);
//output: [,1,0,1,0,0,2,0,2]

tmTopRange(t, x, window=4);
// output: [,1,0,1,0,0,2,0,3]

index = take(datehour(2019.06.13 13:30:10),4) join (datehour(2019.06.13 13:30:10)+1..6)
data = 1 NULL 3 4 5 NULL 3 NULL 5 3
tmTopRange(index, data, 4h)
// output: [0,0,2,3,4,0,1,0,3,0]
```

**Parent topic:**[Functions](../../Functions/category.md)

