# test {#test}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`test(scriptFile, [outputFile], [testMemLeaking=false])`

## Arguments {#arguments}

**scriptFile** is a string indicating the path of a testing script file or a folder.

**outputFile** \(optional\) is a string indicating the path of a test result script file or a folder.

**testMemLeaking** \(optional\) is a Boolean value indicating whether to test for memory leaks.

## Details {#details}

A system command for unit testing. It must be executed by a logged-in user.

If *scriptFile* is a folder, all script files in the folder will be tested.

If *outputFile* is not specified, the testing result will be displayed on screen. If *outputFile* is specified as a relative path, the testing result file will be output to &lt;HomeDir&gt;.

## Examples {#examples}

```
test("C:/DolphinDB/test/test1.txt", "C:/DolphinDB/testResult/test1.txt");
test("C:/DolphinDB/test");
```

