# tensor {#tensor}

## Syntax {#syntax}

`tensor(X)`

## Arguments {#arguments}

**X** can be a scalar, vector, tuple, columnar tuple, matrix or table. These data types are supported: BOOL, CHAR, SHORT, INT, LONG, FLOAT, DOUBLE

## Details {#details}

Generate a tensor from *X* with the following rules:

|**X**|**Output**|
|:----|:---------|
|scalar|1D tensor|
|vector|1D tensor|
|columnar tuple|2D tensor|
|matrix|2D tensor|
|table \(with all columns of the same type\)|2D tensor|
|tuple of vectors \(each element is a vector of the same type\)|2D tensor|
|tuple of matrices \(each element is a matrix with the same dimensions and type\)|3D tensor|
|tuple of tuples \(each element is a tuple, and each element of the sub-tuples is a vector of the same type\)|3D tensor|
|n-level nested tuple|n-D tensor \(where *n* &lt;= 10\)|

Note: Tensors are mainly used with the DolphinDB plugins \(such as LibTorch\) for data exchange with deep learning frameworks. DolphinDB does not currently support direct storage and computation of tensors, nor direct access or modification to their elements.

## Examples {#examples}

``` {#codeblock_v43_q1s_zbc}
//generate tensor from a scalar
/* output 1D tensor of size 1: tensor<int[1]>:
0: int 3
*/

//from a vector
/*tensor<int[3]>:
0: int 1
1: int 2
2: int 3
*/

//from a columnar tuple
tp = [[1.3,2.5,2.3], [4.1,5.3,5], [4.1,5.3,5]]
tp.setColumnarTuple!()
tensor(tp)

/*tensor<double[3][3]>: 
0: double[3] [1.3, 2.5, 2.3]
1: double[3] [4.1, 5.3, 5]
2: double[3] [4.1, 5.3, 5] 
 */

//from a matrix
m= 1..6$2:3
tensor(m)

/*tensor<int[2][3]>: 
0: int[3] [1, 3, 5]
1: int[3] [2, 4, 6]
*/

//from a table
t=table(1..5 as id1, 6..10 as id2)
tensor(t)

/*tensor<int[5][2]>: 
0: int[2] [1, 6]
1: int[2] [2, 7]
2: int[2] [3, 8]
3: int[2] [4, 9]
4: int[2] [5, 10]
*/

//from a tuple
tp1 = [[1.3,2.5,2.3], [4.1,5.3,5], [4.1,5.3,5]]
tensor(tp1)

/*tensor<double[3][3]>: 
0: double[3] [1.3, 4.1, 4.1]
1: double[3] [2.5, 5.3, 5.3]
2: double[3] [2.3, 5, 5]
*/

//from a tuple of matrixs
m1= 1..6$2:3
m2=4..9$2:3
tensor([m1,m2])

/*tensor<int[2][2][3]>:
0: int[2][3]
1: int[2][3]
*/

//from a tuple of tuples
tp1 = [[1.3,2.5,2.3], [4.1,5.3,5], [4.1,5.3,5]]
tp2 = [[1.1,1.2,1.4], [1.5,1.2,1.6], [1.3,1.5,1.8]]
tensor([tp1, tp2])

/*tensor<double[2][3][3]>:
0: double[3][3]
1: double[3][3]
*/

//from a nested tuple
tp1 = [[1.3,2.5,2.3], [4.1,5.3,5], [4.1,5.3,5]]
tp2 = [[1.1,1.2,1.4], [1.5,1.2,1.6], [1.3,1.5,1.8]]
tp3 = [[2.1,6.2,4.4], [3.5,1.9,3.6], [1.8,3.5,9.8]]
tensor([[tp1, tp2],[tp1, tp3]])

/*tensor<double[2][2][3][3]>:
0: double[2][3][3]
1: double[2][3][3]
*/
```

