# temporalParse {#temporalparse}

## Syntax {#syntax}

`temporalParse(X, format)`

Alias: datetimeParse

## Arguments {#arguments}

**X** is a string scalar/vector to be converted to temporal data types.

**format** is a string indicating a temporal format.

## Details {#details}

Convert a string with specified format to a DolphinDB temporal data type. Return NULL if it cannot decide on the data type.

DolphinDB has the following temporal formats:

|Format|Meaning|Range of value|
|------|-------|--------------|
|yyyy|year \(4 digits\)|1000-9999|
|yy|year \(2 digits\)|00-99. \(00-39: 2000-2039; 40-99: 1940-1999\)|
|MM|month in year|1-12|
|MMM|month in year|JAN, FEB, ... DEC \(case insensitive\)|
|dd|day in month|1-31|
|HH|hour in day|0-23|
|hh|hour in AM/PM|0-11|
|mm|minute in hour|0-59|
|ss|second in minute|0-59|
|aa|AM/PM marker|AM, PM. \(case-insensitive\)|
|SSS|millisecond|0-999|
|nnnnnn|microsecond|0-999999|
|nnnnnnnnn|nanosecond|0-999999999|

The parameter format of the *temporalParse* function has 2 types of representation:

-   **With deliminator\(s\)**

Any symbol or character is treated as a deliminator except the characters that are used to express a temporal format: y, M, d, H, h, m, s, a, S, and n. A deliminator in the parameter *format* should be identical as the deliminator in the input string.

```
temporalParse("14-02-2018","dd-MM-yyyy");
// output: 2018.02.14

temporalParse("14-02-2018","dd/MM/yyyy");
// output: 00d

temporalParse("14//02//2018","dd//MM//yyyy");
// output: 2018.02.14

temporalParse("14//02//2018","dd/MM/yyyy");
// output: 00d

temporalParse("14//02//2018","dd..MM..yyyy");
// output: 00d
```

We can simplify the formats by using a single letter between deliminators for the parameter *format*. For example, we can use the format "y/M/d" instead of "yyyy/MM/dd" for "2018/01/16". As "y" may mean both "yyyy" and "yy", for this case the system decides on the format based on the number of digits between deliminators.

```
temporalParse("14-02-18","d-M-y");
// output: 2018.02.14

temporalParse("2018/2/6 02:33:01 PM","y/M/d h:m:s a");
// output: 2018.02.06T14:33:01
```

"MMM","SSS", "nnnnnn" and "nnnnnnnnn", however, cannot be simplified to a single letter.

```
temporalParse("02-FEB-2018","d-MMM-y");
// output: 2018.02.02

temporalParse("02-FEB-2018","d-M-y");
// output: 00d

temporalParse("13:30:10.001","H:m:s.SSS");
// output: 13:30:10.001

temporalParse("13:30:10.001","H:m:s.S");
// output: Invalid temporal format: 'H:m:s.S'. Millisecond (S) must have three digits.

temporalParse("13:30:10.008001","H:m:s.nnnnnn");
// output: 13:30:10.008001000

temporalParse("13:30:10.008001","H:m:s.n");
// output: Invalid temporal format: 'H:m:s.n'. Nanosecond (n) must have six or nine digits.
```

The `temporalParse` function is very flexible in interpreting the numbers between deliminators in the input string.

```
temporalParse("2-4-18","d-M-yy");
// output: 2018.04.02

temporalParse("2-19-6","H-m-s");
// output: 02:19:06

temporalParse("002-019-006","H-m-s");
// output: 02:19:06
```

For millisecond, microsecond and nanosecond, however, the corresponding number of digits in the input string must be 3, 6 and 9 respectively.

```
temporalParse("2018/2/6 13:30:10.001","y/M/d H:m:s.SSS");
// output: 2018.02.06T13:30:10.001

temporalParse("2018/2/6 13:30:10.01","y/M/d H:m:s.SSS");
// output: 00T

temporalParse("2018/2/6 13:30:10.000001","y/M/d H:m:s.nnnnnn");
// output: 2018.02.06T13:30:10.000001000

temporalParse("2018/2/6 13:30:10.0000010","y/M/d H:m:s.nnnnnn");
// output: 00N
```

If a character that is used to express a temporal format \(y, M, d, H, h, m, s, a, S, n\) appears in the input string as a deliminator, we need to use "" before the character in parameter *format*.

```
temporalParse("2013a02", "y\\aM");
// output: 2013.02M

temporalParse("2013an02", "y\\a\\nM");
// output: 2013.02M
```

-   **Without deliminators**

For this reprensentation, the parameter *format* must be composed of the formats in the temporal formats table. We cannot use a single letter to represent a format in the temporal format table.

```
temporalParse("20180214","yyyyMMdd");
// output: 2018.02.14

temporalParse("122506","MMddyy");
// output: 2006.12.25

temporalParse("155950","HHmmss");
// output: 15:59:50

temporalParse("035901PM","hhmmssaa");
// output: 15:59:01

temporalParse("02062018155956001000001","MMddyyyyHHmmssnnnnnnnnn");
// output: 2018.02.06T15:59:56.001000001
```

