# temporalFormat {#temporalformat}

## Syntax {#syntax}

`temporalFormat(X, format)`

Alias: datetimeFormat

## Arguments {#arguments}

**X** is a scalar/vector of temporal data types.

**format** is a string indicating a temporal format.

## Details {#details}

Convert a DolphinDB temporal variable to a string with specified format. For details about DolphinDB temporal formats, please check the section [Parsing and Format of Temporal Variables](../../Programming/DataManipulation/TemporalObjects/ParsingandFormatofTemporalVariables.md).

## Examples {#examples}

```
temporalFormat(2018.02.14,"dd-MM-yyyy");
// output: 14-02-2018

temporalFormat(2018.02.14,"dd-MMM-yy");
// output: 14-FEB-18

temporalFormat(02:19:06,"HH.mm.ss");
// output: 02.19.06

temporalFormat(2018.02.06T13:30:10.001, "y-M-d-H-m-s-SSS");
// output: 2018-2-6-13-30-10-001

temporalFormat(14:19:06,"hhmmssaa");
// output: 021906PM
```

