# temporalAdd {#temporaladd}

## Syntax {#syntax}

`temporalAdd(obj, duration, unit)`

Alias: datetimeAdd

## Arguments {#arguments}

**obj** is a temporal scalar/pair/vector.

**duration** is an integer.

**unit** is a STRING vector.

-   When parameter *duration* is an integer, *unit* is:

    -   the unit of parameter *duration*. It can be "ns"\(nanosecond\), "us"\(microsecond\), "ms"\( millisecond\), "s"\(second\), "m"\(minute\), "H"\(hour\), "d"\(day\), "w"\(week\), "M"\(month\), "y"\( year\), or "B"\(business day\).

    -   the identifier of trading calendar, e.g., the Market Identifier Code of an exchange, or a user-defined calendar name. The corresponding file must be saved in *marketHolidayDir*.

-   When *duration* is of DURATION type, this parameter is not required.


**Note:** When *unit* is "y" or "M", the result is consistent with mysql. Pandas provides an offset object *Dateoffsets* to move dates forward a given number of valid dates. When the *DateOffset* parameter is specified as months or years, the result is also consistent with *temporalAdd*.

## Details {#details}

Add a value to a temporal variable.

## Examples {#examples}

```
temporalAdd(2017.01.16,1,"d");
// output: 2017.01.17

temporalAdd(2017.01.16,1,"w");
// output: 2017.01.23

temporalAdd(2016.12M,2,"M");
// output: 2017.02M

temporalAdd(2012.07.31T13:30:10.008,-1,'M');
// output: 2012.06.30T13:30:10.008

temporalAdd(2012.07.31T13:30:10.008,1,'y');
// output: 2013.07.31T13:30:10.008

temporalAdd(13:30:10.008007006,100,"ns");
// output: 13:30:10.008007106

x=[12:23:34, 23:34:45];
temporalAdd(x, 10m);
// output: [12:33:34,23:44:45]
```

Add four business days to 2021.08.06.

```
temporalAdd(2021.08.06, 4B)
// output: 2021.08.12
```

Add 2 trading days for "date" according to the trading calendar CFFEX.

```
date=[2023.01.01, 2023.01.02, 2023.01.03, 2023.01.04]
temporalAdd(date,2,`CFFEX)
// output: [2023.01.04,2023.01.04,2023.01.05,2023.01.06]
```

```
temporalAdd(datetime(2020.08.31), -2M)
// output: 2020.06.30T00:00:00

//The result is the same as setting months=2 in pandas *DateOffset*.
pd1 = pd.Timestamp("2020.08.31")
print(pd1 -pd.offsets.DateOffset(months=2))
// output: 2020-06-30 00:00:00

temporalAdd(datetime(2020.02.29), -1y)
// output: 2019.02.28T00:00:00
temporalAdd(datetime(2020.02.29), -4y)
// output: 2016.02.29T00:00:00

//The result is the same as setting years=1 in pandas *DateOffset*.
pd1 = pd.Timestamp("2020.02.29")
print(pd1 - pd.offsets.DateOffset(years=1))
// output: 2019-02-28 00:00:00

//The result is the same as setting years=4 in pandas *DateOffset*.
pd2 = pd.Timestamp("2020.02.29")
print(pd2 - pd.offsets.DateOffset(years=4))
// output: 2016-02-29 00:00:00
```

