# tail {#tail}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`tail(obj, [n=1])`

## Arguments {#arguments}

**obj** is a vector/matrix/table.

**n** \(optional\) is a positive integer. The default value is 1.

## Details {#details}

Return the last n element\(s\) of a vector, or the last n columns of a matrix, or the last n rows of a table.

## Examples {#examples}

```
x=1..10;
tail(x);
// output: 10

tail(x,2);
// output: [9,10]

x=1..10$2:5;
x;
```

|\#0|\#1|\#2|\#3|\#4|
|---|---|---|---|---|
|1|3|5|7|9|
|2|4|6|8|10|

```
x.tail();
// output: [9,10]

tail(x,2);
```

|\#0|\#1|
|---|---|
|7|9|
|8|10|

```
x=table(1..5 as a, 6..10 as b);
x;
```

|a|b|
|---|---|
|1|6|
|2|7|
|3|8|
|4|9|
|5|10|

```
tail(x);
/* output:
b->10
a->5
*/

x.tail(2);
```

|a|b|
|---|---|
|4|9|
|5|10|

Related function: [head](../h/head.md)

