# tableInsert {#tableinsert}

## Syntax {#syntax}

`tableInsert(table, args...)`

## Arguments {#arguments}

**table** is a table object or a table name. The table can be either an in-memory table or a DFS table. In remote call, it must be a table name as we don't have the reference of a table object.

**args...** can be a table/tuple/dictionary.

## Details {#details}

Insert *args*... into table. Return the number of rows inserted from the operation.

If *args*... is a table, it must have the same schema as table. If *table* is a partitioned table, *args*... must be a table.

If *args*... is a tuple, it must have the same number of elements as the number of columns of *table* and each element of *args*... must have the same data type as the corresponding column of table.

If *args*... is multiple vectors or tuples, the number of its elements must be the same as the number of columns of *table* and each vector or tuple must have the same data type as the corresponding column of table.

If *args*... is a dictionary, its keys correspond to the column names of *table*. The values of *args*... must be a tuple. For this scenario *table* must be an in-memory table.

## Examples {#examples}

```
colName=["Name","Age"]
colType=["string","int"]
t1=table(100:0,colName, colType);

name=`Tom`Jerry`John
age=24 25 26
t2=table(name, age)

tableInsert(t1, t2);
// output: 3

t1;
```

|Name|Age|
|----|---|
|Tom|24|
|Jerry|25|
|John|26|

```
tableInsert(t1, (`George, 29));
// output: 1

t1;
```

|Name|Age|
|----|---|
|Tom|24|
|Jerry|25|
|John|26|
|George|29|

```
tableInsert(t1, (`Frank`Henry, 31 32));
// output: 2

tableInsert(t1, `Nicole`Nancy, 28 29);
// output: 2

t1.tableInsert(dict(`Name`Age, [`Patrick, 22]));
// output: 1
```

Insert data into a DFS table:

```
db=database("dfs://db1",RANGE,0 20 50 101)
n=100000
id=rand(100,n)
val=rand(100.0,n)
t=table(id,val)
pt=db.createPartitionedTable(t,`pt,`id).append!(t);

tmp=table(rand(100,10000) as id,take(200.0,10000) as val);

tableInsert(pt,tmp);
// output: 10000
```

