# t3 {#t3}

## Syntax {#syntax}

`t3(X, window, [vfactor=1.0])`

Please see [TALib](../Themes/TALib.md) for the parameters and windowing logic.

## Arguments {#arguments}

**vfactor** \(optional\) is a floating-point number in \[0,1\]. The default value is 1.0.

## Details {#details}

Calculate the Triple Exponential Moving Average \(t3\) for *X* in a sliding window of the given length.

The formula is

![](../../images/ema1.png)

![](../../images/ema2.png)

![](../../images/gd.png)

![](../../images/t3.png)

## Examples {#examples}

```
x=12.1 12.2 12.6 12.8 11.9 11.6 11.2 16.9 55.6 5.6 3.3 66 6 57
t3(x, 3, 0.5);
// output: [,,,,,,,,,,,,26.84,33.21]

x=matrix(12.1 12.2 12.6 12.8 11.9 11.6 11.2 15.7 18.6 13.2 19.6 20.3 22.4 11, 14 15 18 19 21 12 10 6 5.5 7 11 16 15 9.9)
t3(x, 3, 0.8);
```

|col1|col2|
|----|----|
|||
|||
|||
|||
|||
|||
|||
|||
|||
|||
|||
|||
|20.76|13.47|
|18.24|13.24|

Related function: [tema](tema.md)

