# symbolCode {#symbolcode}

## Syntax {#section_a5b_vw2_czb .section}

`symbolCode(X)`

## Arguments {#section_gwr_vw2_czb .section}

**X** is a vector/matrix of SYMBOL type.

## Details {#section_frf_ww2_czb .section}

SYMBOL is a special STRING type used to store repetitive strings in DolphinDB. Internally, data of SYMBOL type is encoded into integers and stored as a dictionary. The internal encoding of an empty string is 0.

For each element in *X*, this function returns its internal encoding. The return value is of the same dimension as *X*.

It is recommended to use the SYMBOL type if there are a lot of duplicate values for a certain field such as device ID and stock symbol to improve storage efficiency.

## Examples {#section_nby_ww2_czb .section}

``` {#codeblock_tj4_xw2_czb}
a=symbol(`IBM`APPL)
symbolCode(a)
// output: [1,2]

x=symbol(`MS`AMZN`AAPL`MS`IBM`AAPL)$3:2
symbolCode(x)

/* output:
#0 #1
 -- --
1  1 
2  4 
3  3 
*/
```

**Parent topic:**[Functions](../../Functions/category.md)

