# svd {#svd}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`svd(obj, [fullMatrices=true], [computeUV=true])`

## Arguments {#arguments}

**obj** is a matrix.

**fullMatrices** \(optional\) is a Boolean value. The default value is true.

**computeUV** \(optional\) is a Boolean value. The default value is true.

## Details {#details}

Perform the singular decomposition of a matrix.

Given an m-by-n matrix A:

-   If *fullMatrices*=true, return an m-by-m matrix U \(unitary matrix having left singular vectors as columns\), an n-by-n matrix V \(unitary matrix having right singular vectors as rows\) and a vector s \(singular values sorted in descending order\) such that A=U\*S\*V. S is an m-by-n matrix with s as the diagonal elements.
-   If *fullMatrices*=false, remove the extra rows or columns of zeros from matrix S, along with the columns/rows in U and V that multiply those zeros in the expression A = U\*S\*V. Removing these zeros and columns/rows can improve execution time and reduce storage requirements without compromising the accuracy of the decomposition. The resulting matrix U is m-by-k, matrix V is k-by-n and matrix S is k-by-k with k=min\(m,n\).
-   If *computeUV*=false, only return vector s.

## Examples {#examples}

```
m=matrix([[2,1,0],[1,3,1],[0,1,4],[1,2,3]]);
U,s,V=svd(m);
U;
```

|\#0|\#1|\#2|
|---|---|---|
|-0.233976|0.57735|-0.782254|
|-0.560464|0.57735|0.593756|
|-0.79444|-0.57735|-0.188498|

```
s;
// output: [6.029042,3,1.284776]

V;
```

|\#0|\#1|\#2|\#3|
|---|---|---|---|
|-0.170577|-0.449459|-0.620036|-0.620036|
|0.57735|0.57735|-0.57735|0|
|-0.755582|0.630862|-0.12472|-0.12472|
|-0.258199|-0.258199|-0.516398|0.774597|

```
U,s,V=svd(m,fullMatrices=false);
V;
```

|\#0|\#1|\#2|\#3|
|---|---|---|---|
|-0.170577|-0.449459|-0.620036|-0.620036|
|0.57735|0.57735|-0.57735|0|
|-0.755582|0.630862|-0.12472|-0.12472|

