# sumbars {#sumbars}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`sumbars(X, Y)`

## Arguments {#arguments}

**X** is a vector/tuple/matrix/table whose elements must be non-negative numbers.

**Y** is a scalar indicating the threshold.

## Details {#details}

For each element X i in *X*, calculate the cumulative sum of X i in the backward direction, i.e., \(X i + X i-1 + X i-2 …\), until the value is no smaller than *Y*.

If the cumulative sum never exceeds *Y*, return 0.

## Examples {#examples}

```
sumbars(1 2 3.3 2 5, 3)
// output: [0,2,1,2,1]

sumbars(matrix(5 3 6 2 3, 2 6 1 5 4), 5)
```

|col1|col2|
|----|----|
|1|0|
|2|1|
|1|2|
|2|1|
|2|2|

```
// calculate the turnover period
id = `A`A`B`A`C`B`A`C`A`B
time = 2022.01.01T09:00:00 + 0..9
volume = 100 150 80 120 220 200 180 90 100 125
t = table(id, time, volume)
capital = 300
re = select *, sumbars(volume, capital) as period from t
re;
```

|id|time|volume|period|
|---|----|------|------|
|A|2022.01.01T09:00:00|100|0|
|A|2022.01.01T09:00:01|150|0|
|B|2022.01.01T09:00:02|80|3|
|A|2022.01.01T09:00:03|120|3|
|C|2022.01.01T09:00:04|220|2|
|B|2022.01.01T09:00:05|200|2|
|A|2022.01.01T09:00:06|180|2|
|C|2022.01.01T09:00:07|90|3|
|A|2022.01.01T09:00:08|100|3|
|B|2022.01.01T09:00:09|125|3|

