# sum4 {#sum4}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`sum4(X)`

## Arguments {#arguments}

**X** is a scalar/vector/matrix/table.

## Details {#details}

If *X* is a vector, return the sum of the fourth powers of all the elements in *X*.

If *X* is a matrix, calculate the sum of the fourth powers for each column of *X* and return a vector.

If *X* is a table, calculate the sum of the fourth powers for each column of *X* and return a table.

As with all aggregate functions, null values are not included in the calculation.

If all elements of a calculation are null values, the result is NULL.

Please note that the data type of the result is always DOUBLE, even if the data type of X is INT or LONG.

## Examples {#examples}

```
sum4(1 2 3);
// output: 98

sum4(1 NULL NULL);
// output: 1

sum4(1.5 4.6 7.8);
// output: 4154.3137

m=matrix(1 2 3, 4 5 6);
m;
```

|\#0|\#1|
|---|---|
|1|4|
|2|5|
|3|6|

```
sum4(m);
// output: [98,2177]
```

