# sum {#sum}

## Syntax {#syntax}

`sum(X)`

## Arguments {#arguments}

**X** is a scalar/vector/matrix/table.

## Details {#details}

If *X* is a vector, return the sum of all the elements in *X*.

If *X* is a matrix, calculate the sum of each column of *X* and return a vector.

If *X* is a table, calculate the sum of each column of *X* and return a table.

As with all aggregate functions, null values are not included in the calculation.

If all elements of a calculation are null values, the result is NULL.

## Examples {#examples}

```
sum(1 2 3 NULL 4);
// output: 10

m=matrix(1 2 3, 4 5 6);
m;
```

|\#0|\#1|
|---|---|
|1|4|
|2|5|
|3|6|

```
sum(m);
// output: [6,15]
```

