# subtuple {#subtuple}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`subtuple(X, range)`

## Arguments {#arguments}

**X** is a tuple of vectors with the same length.

**range** is a pair of integers indicating a range. The lower bound is inclusive and the upper bound is exclusive.

## Details {#details}

Create a read-only view of a subarray of each vector in *X* almost instantly. In contrast, it takes time to create a new tuple of vectors.

## Examples {#examples}

Example 1:

```
x=(1..10, 11..20, 21..30, 31..40)
subtuple(x, 2:4);
// output: ([3,4],[13,14],[23,24],[33,34])
```

Example 2

```
m=1000.0
n=20000000
a=(rand(m,n), rand(m,n))
k=10000000;
timer each(avg, a.subtuple(0:k));
// Time elapsed: 30.87 ms

timer each(avg, (a[0][0:k], a[1][0:k]));
// Time elapsed: 46.508 ms
```

Example 3. Subtuples are read-only.

```
x=(1..10, 11..20)
subtuple(x, 2:4)=([4, 5], [14, 15]);
// output: Syntax Error: [line #2] Please use '==' rather than '=' as equal operator in non-sql expression.
```

