# subscribeStreamingSQL {#subscribeStreamingSQL}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`subscribeStreamingSQL([server], queryId,[batchSize=0],[throttle=1],[hash=-1])`

## Arguments {#arguments}

**server** \(optional\) A STRING scalar representing the alias or remote connection handle of the node running streaming SQL query \(i.e., the server where the query was registered\). If not specified or an empty string, the server hosting the query is the local instance.

**queryId** A STRING scalar representing the ID name for the streaming SQL query to subscribe.

**batchSize** \(optional\) An INTEGRAL scalar which defaults to 0.

-   Positive integer: Process incremental logs only when the unprocessed number reaches *batchSize*.
-   Non-positive or unspecified: Process each batch of incremental logs as they arrive.

**throttle** \(optional\) A floating point which defaults to 1 \(in second\), specifying the maximum interval after the last log processing. If *batchSize* is not met within this period, logs are processed again.

-   If *batchSize* is not specified, *throttle* has no effect even if set.
-   To set *throttle* to less than 1 second, modify the configuration parameter *subThrottle* first.

**hash** \(optional\) A non-negative integer specifying the subscription thread that processes incoming log messages. If not specified, the system automatically assigns a thread. To process messages of multiple subscription tasks with the same thread, set their hashes to the same value.

## Details {#details}

Subscribe to the results of a specified streaming SQL query. The subscriber receives incremental logs and uses them to maintain a shared result table that is updated in real time, ensuring the query results stay continuously refreshed as data changes.

**Return value**: A table containing columns of the result for the streaming SQL query.

## Examples {#examples}

``` {#codeblock_y55_32x_mgc}
t=table(1..10 as id,rand(100,10) as val)
share t as st
declareStreamingSQLTable(st)
registerStreamingSQL("select avg(val) from st","sql_avg") 

subscribeStreamingSQL(queryId="sql_avg")
```

|avg\_val|
|--------|
|64.3|

**Related functions:** [declareStreamingSQLTable](../d/declareStreamingSQLTable.md), [registerStreamingSQL](../r/registerStreamingSQL.md), [unsubscribeStreamingSQL](../u/unsubscribeStreamingSQL.md)

