# submitJobEx2 {#submitjobex2}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`submitJobEx2(jobId, jobDesc, priority, parallelism, onComplete, jobDef, args...)`

## Arguments {#arguments}

**jobId** is a string indicating the job ID.

**jobDesc** is a string of the job description.

**priority** is an integer from 0 to 9 indicating the importance of the job. 9 means the most important job.

**parallelism** is a positive integer indicating the maximum number of workers allocated to the job.

**onComplete** is a callback function that executes after the submitted batch job finishes \(including job completion or failure\). The function accepts four arguments:

-   jobId: Job ID.
-   jobDesc: Job description.
-   success: Whether the job has completed successfully.
-   result: Job execution result.

**jobDef** is a local function that defines the job. Please note that it is not the function name, and therefore it should not be quoted.

**args...** is the arguments of the local function. If the function has no arguments, it is unspecified.

## Details {#details}

Submit a batch job to the local node and return the job ID for future reference. Different from `submitJobEx`, `submitJobEx2` will execute the callback function after the submitted job is finished.

## Examples {#examples}

``` {#codeblock_ejw_4rh_d1c}
def jobDemo(n){
    s = 0
    for (x in 1 : n) {
        s += sum(sin rand(1.0, 100000000)-0.5)
        print("iteration " + x + " " + s)
    }
    return s
}

def cbFunc(jobId, jobDesc, success, result){
    desc = jobId + " " + jobDesc
    if(success){
        desc += " successful " + result
    }
    else{
        desc += " with error: " + result
    }
    writeLog(desc)
}

submitJobEx2("jobDemo1","job demo", 8, 12, cbFunc, jobDemo, 100)
```

