# submitJobEx {#submitjobex}

## Syntax {#syntax}

`submitJobEx(jobId, jobDesc, priority, parallelism, jobDef, args...)`

## Arguments {#arguments}

**jobId** is a string indicating the job ID.

**jobDesc** is a string of the job description.

**priority** is an integer from 0 to 9 indicating the importance of the job. 9 means the most important job.

**parallelism** is a positive integer indicating the maximum number of workers allocated to the job.

**jobDef** is a local function that defines the job. Please note that it is not the function name, and therefore it should not be quoted.

**args...** is the arguments of the local function. If the function has no arguments, it is unspecified.

## Details {#details}

Submit a batch job to the local node and return the job ID for future reference. The only difference between `submitJobEx` and [submitJob](submitJob.md) is that we can specify parameters *priority* and *parallelism* in `submitJobEx`.

## Examples {#examples}

```
def jobDemo(n){
    s = 0
    for (x in 1 : n) {
        s += sum(sin rand(1.0, 100000000)-0.5)
        print("iteration " + x + " " + s)
    }
    return s
};

submitJobEx("jobDemo1","job demo", 8, 12, jobDemo, 100);
// output: jobDemo1
```

