# streamTable {#streamtable}

## Syntax {#syntax}

`streamTable(X, [X1], [X2], ....)`

or

`streamTable(capacity:size, colNames, colTypes)`

## Arguments {#arguments}

For the first scenario: **X**, **X1**, **X2** ... can be vectors, matrices or tuples. Each vector, each matrix column and each tuple element must have the same length. **When _Xk_is a tuple:**

-   If the elements of *Xk*are vectors of equal length, each element of the tuple will be treated as a column in the table.
-   If *Xk*contains elements of different types or unequal lengths, it will be treated as a single column in the table \(with the column type set to ANY\), and each element will correspond to the value of that column in each row.

For the second scenario:

-   **capacity** is a positive integer indicating the amount of memory \(in terms of the number of rows\) allocated to the table. When the number of rows exceeds capacity, the system will first allocate memory of 1.2~2 times of capacity, copy the data to the new memory space, and release the original memory. For large tables, these steps may use significant amount of memory.

-   **size** is an integer no less than 0 indicating the initial size \(in terms of the number of rows\) of the table. If *size*=0, create an empty table; If *size*&gt;0, the initialized values are:

    -   false for Boolean type;

    -   0 for numeric, temporal, IPADDR, COMPLEX, and POINT types;

    -   Null value for Literal, INT128 types.

    **Note:** If *colTypes* is an array vector, *size* must be 0.

-   **colNames** is a STRING vector of column names.

-   **colTypes** is a STRING vector of data types. It can use either the reserved words for data types or corresponding strings.


## Details {#details}

Create a table in real-time mode to be used in streaming \(also called a stream table\). A table in real-time mode can handle concurrent reading and writing.

## Examples {#examples}

```
id=`XOM`GS`AAPL
x=102.1 33.4 73.6
rt = streamTable(id, x);
rt=streamTable(`XOM`GS`AAPL as id, 102.1 33.4 73.6 as x);
colName=["Name","Age"]
colType=["string","int"]
rt = streamTable(100:10, colName, colType);
```

