# stl {#stl}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`stl(data, period, sWindow, [sDegree], [sJump], [tWindow], [tDegree], [tJump], [lWindow], [lDegree], [lJump], [robust], [inner], [outer])`

## Details {#details}

**data** is a numeric vector.

**period** is an integer larger than 1 indicating the length of a time-series cycle.

**sWindow** is either the string "periodic" that means smoothing is effectively replaced by taking the mean, or an odd number no smaller than 7 indicating the span \(in lags\) of the loess window for seasonal extraction.

**sDegree** \(optional\) can be 0, 1 or 2 indicating the degree of locally-fitted polynomial in seasonal extraction. The default value is 1.

**sJump** \(optional\) is an integer greater than 1 indicating the number of elements to skip for the smoother in seasonal extraction. The default value is ceil\(sWindow/10\).

**tWindow** \(optional\) is a positive odd number indicating the span \(in lags\) of the loess window for trend extraction. The default value is the next odd number after 1.5 \* period / \(1 - \(1.5 / sWindow\)\).

**tDegree** \(optional\) can be 0, 1 or 2 indicating the degree of locally-fitted polynomial in trend extraction. The default value is 1.

**tJump** \(optional\) is an integer greater than 1 indicating the number of elements to skip for the smoother in trend extraction. The default value is ceil\(sWindow/10\).

**lWindow** \(optional\) is a positive odd number indicating the the span \(in lags\) of the loess window of the low-pass filter used for each subseries. The default value is the next odd number after period.

**lDegree** \(optional\) can be 0, 1 or 2 indicating the degree of locally-fitted polynomial for the subseries low-pass filter. The default value is 1.

**lJump** \(optional\) is an integer greater than 1 indicating the number of elements to skip for the smoother in the subseries low-pass filter. The default value is ceil\(sWindow/10\).

**robust** \(optional\) is a Boolean value indicating if robust fitting is used in the loess procedure. The default value is false.

**inner** \(optional\) is a positive integer indicating the number of 'inner' \(backfitting\) iterations; usually very few \(2\) iterations suffice. If *robust*=true, the default value of *inner* is 1; if *robust*=false, the default value of *inner* is 2.

**outer** \(optional\) is a positive integer indicating the number of 'outer' robustness iterations. If *robust*=true, the default value of *outer* is 15; if *robust*=false, the default value of *outer* is 0.

## Details {#details-1}

Use Loess method to decompose a time series into trend, seasonality and randomness. The result is a dictionary with the following keys: trend, seasonal, and residual. Each key corresponds to a vector with the same length as data.

## Examples {#examples}

```
n = 100
trend = 6 * sin(1..n \ 200)
seasonal = sin(pi / 6 * 1..n)
residual = rand(1.0, n) - 0.5
data = trend + seasonal + residual
res = stl(data, 12, "periodic");

plot([trend, res.trend]);
```

![](../../images/stl01.png)

```
plot([seasonal, res.seasonal]);
```

![](../../images/stl02.png)

