# stdp {#stdp}

## Syntax {#syntax}

`stdp(X)`

## Arguments {#arguments}

**X** is a vector/matrix/table.

## Details {#details}

If *X* is a vector, return the population standard deviation of *X*.

If *X* is a matrix, calculate the population standard deviation of each column and return a vector.

If *X* is a table, calculate the population standard deviation of each column and return a table.

As with all other aggregate functions, null values are not included in the calculation.

## Examples {#examples}

```
stdp(1 2 3);
// output: 0.816497

m=matrix(1 3 5 7 9, 1 4 7 10 13);
m;
```

|\#0|\#1|
|---|---|
|1|1|
|3|4|
|5|7|
|7|10|
|9|13|

```
stdp(m);
// output: [2.8284,4.2426]
```

