# startStreamGraph {#startStreamGraph}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`startStreamGraph(name)`

## Arguments {#arguments}

**name** is a string representing the name of the stream graph. You can provide either the fully qualified name \(FQN\), such as "catalog\_name.orca\_graph.graph\_name", or just the graph name, like "factors". If only the name is given, the system will automatically complete it using the current catalog.

## Details {#details}

Restart the specified stream graph. After successful execution, the stream graph status will be set to running. You can check the status through `getStreamGraphMeta`.

When using this feature, it is recommended to explicitly set the data source consumption policy \(subscription.sourceOffset\) via `setConfigMap` to control how data is handled during pauses.

-   sourceOffset = -1 \(recommended\): Upon restarting the stream graph, consumption resumes from the latest record in the source table. Data ingested during the pause is ignored. Suitable for scenarios where only real-time data is required and historical data during the pause can be discarded.
-   sourceOffset = -3 \(default, use with caution\): Upon restarting the stream graph, consumption restarts from the first record in the source table, replaying all historical data. This may consume significant resources and cause duplicate computations. Suitable for scenarios where absolute data completeness is required and the source table size is manageable.

**Return value**: None

## Examples {#examples}

``` {#codeblock_hgp_xgp_mgc}
if (!existsCatalog("orca")) {
	createCatalog("orca")
}
go

use catalog orca

def callTimes(mutable call, mutable tempTable, msg) {
    call += 1
    price = [call]
    volume = [call]
    t = table(price, volume)
    tempTable.append!(t)
    return t
}
name = "UDF"
g = createStreamGraph(name)
ckptConfig = {
    "enable":true,
    "interval": 10000,
    "timeout": 36000,
    "maxConcurrentCheckpoints": 1
};

g.source("trade", `price`volume, [INT,INT])
 .udfEngine(callTimes,["price", "volume"], [`cnt, `tmpTable], [433, table(128:0, ["price","volume"], [INT, INT])])
 .setEngineName("udf")
 .sink("output")
g.submit(ckptConfig)
go
getStreamGraphMeta()
stopStreamGraph("UDF")
startStreamGraph("UDF") 
```

**Related functions:** [createStreamGraph](../c/createStreamGraph.md), [stopStreamGraph](stopStreamGraph.md)

