# sqlTuple {#sqlTuple}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax-1}

`sqlTuple(colNames)`

## Arguments {#arguments}

**colNames** is a STRING scalar/vector indicating column names.

## Details {#details}

Generate metacode with a tuple expression. The elements of the tuple are specified by *colNames*. `sqlTuple` is usually used with `sql` and `makeUnifiedCall` to dynamically generate SQL statements.

## Examples {#examples}

In the following example, the parameter *args* of `makeUnifiedCall` is tuple metacode generated using `sqlTuple`, and *func* is a user-defined function. The result of `makeUnifiedCall` is passed as the parameter *select* of function `sql` to generate SQL metacode `c`.

``` {#codeblock_cb1_nwc_s1c}
// Create a user-defined function
f = def (x,y)->(x-y)/(x+y)

// Create a table for query
t = table(1.0 2.0 3.0 as qty1, 1.0 3.0 7.0 as qty2)

// Generate metacode for query
c = sql(select=makeUnifiedCall(f, sqlTuple(`qty1`qty2)), from=t)

// Execute the corresponding metacode
c.eval()
```

<table id="table_ssl_nwc_s1c"><thead><tr><th align="left">

**\_qty1**

</th></tr></thead><tbody><tr><td align="left">

0

</td></tr><tr><td align="left">

-0.2

</td></tr><tr><td align="left">

-0.4

</td></tr></tbody>
</table>