# sqlCol {#sqlcol}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`sqlCol(colName, [func], [alias], [qualifier])`

## Arguments {#arguments}

**colName** is a string scalar/vector indicating column name\(s\).

**func** \(optional\) is a unary function.

**alias** \(optional\) is a string scalar/vector indicating column name\(s\) of the selected column\(s\) or calculation result\(s\).

**qualifier** \(optional\) is a STRING scalar. It is only used in a table join operation when we need to select a column that appears in both tables and that is not a matching column. It indicates the table from which to select the column.

## Details {#details}

Generate metacode for selecting one or multiple columns with or without calculations. It is generally used together with function [sql](sql.md) and [eval](../e/eval.md) to generate SQL statements dynamically.

## Examples {#examples}

```
t = table(`GME`AMC`KOSS as symbol, 325 13.26 64 as price);
colName="symbol";
sql(select=sqlCol(colName), from=t).eval();
```

|symbol|
|------|
|GME|
|AMC|
|KOSS|

```
colName="price";
sql(select=sqlCol(colName, max, `maxPrice), from=t).eval();
```

|maxPrice|
|--------|
|325|

```
t1 = table(1 2 3 3 as id, 7.8 4.6 5.1 0.1 as value, 4 3 2 1 as x);
t2 = table(5 3 1 as id,  300 500 800 as qty, 44 66 88 as x) ;
sql(select=(sqlCol(`id),sqlCol(colName=`x, alias="t1_x", qualifier="t1"),sqlCol(colName=`x, alias="t2_x", qualifier=`t2)), from=<ej(t1,t2,`id)>).eval()
```

|id|t1\_x|t2\_x|
|---|-----|-----|
|1|4|88|
|3|2|66|
|3|1|66|

