# splrep {#splrep}

## Syntax {#section_xjd_pn2_czb .section}

`splrep(x, y, t)`

## Arguments {#section_qvw_pn2_czb .section}

**x** and **y** are vectors of Integral/Temporal/Floating/Decimal type that define the data points for the cubic spline curve y = f\(x\). Note that x and y must have the same length, and the input values of y must be in ascending order.

**t** \(optional\) is a vector indicating the knots needed. Splines can have different polynomials on either side of the knots. The values in *t* must satisfy the Schoenberg-Whitney conditions, meaning there must exist a subset of data points x\[j\] for all j=0, 1,...,n-5 such that t\[j\] &lt; x\[j\] &lt; t\[j+4\].

## Details {#section_wsw_sn2_czb .section}

`splrep`, short for Spline Representation, is used to find the B-spline representation of a one-dimensional curve. With a given set of data points \(x\[i\], y\[i\]\), it determines the degree-3 smooth spline approximation over the interval x\[0\] &lt;= x &lt;= x\[size\(x\)-1\]. If null value is included in the input values of *x*, *y*, or *t*, it will be filled with 0.

**Return value**: A tuple of length 3 containing the vector of knots, the B-spline coefficients, and the degree of the spline.

## Examples {#section_c4r_5n2_czb .section}

``` {#codeblock_kfh_vn2_czb}
x = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9]
y = [0, 3, 5, 6, 5, 3, 1, 2, 4, 5]
t=[1,3,5,8]
tck= splrep(x, y, t=t)
print(tck)
// output: ([0,0,0,0,1,3,5,8,9,9,9,9],[0,2.234794827972243,2.999908797063527,8.195517483732592,0.982766102937427,0.416533320193195,6.868465914739519,5,0,0,0,0],3)
```

Related function: [splev](splev.md)

**Parent topic:**[Functions](../../Functions/category.md)

