# split {#split}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`split(str, [delimiter])`

## Arguments {#arguments}

**str** is a STRING scalaror vector.

**delimiter** \(optional\) is a CHAR or STRING scalar indicating the separator. It can consist of one or more characters, with the default being a comma \(','\).

## Details {#details}

-   If *delimiter* is not specified, split *str* into a CHAR vector.

-   If *delimiter* is specified, use *delimiter* as the delimiter to split str into a CHAR vector or a STRING vector.


-   *str* is a scalar:

    -   If *delimiter* is not specified, split *str* into a CHAR vector.

    -   If *delimiter* is specified, use *delimiter* as the delimiter to split str into a CHAR vector or a STRING vector.

-   *str* is a vector: Split each element of the vector as described above. Return the results in a columnar tuple.


## Examples {#examples}

```
split("xyz 1");
// output: ['x','y','z',' ','1']

split("xyz 1"," ");
// output: ["xyz","1"]

split(`xyz1,`xyz);
// output: [,"1"]

split(`xyz1,`xyz)[1];
// output: 1

a = split\("20220101 09:00:00" "20220101 09:12:20" "20220101 10:00:00", " "\)
// output: \(\["20220101","09:00:00"\],\["20220101","09:12:20"\],\["20220101","10:00:00"\]\)

// access by column
a\[0\];
// output: \["20220101","20220101","20220101"\]

a\[1\];
// output: \["09:00:00","09:12:20","10:00:00"\]

//access by row
a.row\(0\)
// output: \["20220101","09:00:00"\]
```

