# splev {#splev}

## Syntax {#section_bmc_hn2_czb .section}

`splev(x, tck)`

## Arguments {#section_ilz_hn2_czb .section}

**x** is a vector that specifies a set of data points to obtain corresponding values on the spline.

**tck** can be a tuple of length 3 or a B-spline curve object that contains a vector t of knots, the B-spline coefficients, and the degree k of the spline. It can be generated with function [splrep](splrep.md). Note that the spline degree k must satisfy 1 &lt;= k &lt;= 5.

## Details {#section_zk1_jn2_czb .section}

`splev`, short for Spline Evaluation, is used to evaluate B-spline curves or their derivatives. Given the knots and coefficients of the B-spline representation, this function calculates the values of the smooth polynomials and their derivatives. If null value is included in the input values of *x* or *tck*, it will be filled with 0.

**Return value**: y, a DOUBLE type vector that represents the array of spline function values evaluated at points x.

**Note:**

It is not recommended to use a user-defined *tck*. If it is not generated by function `splrep`, the returned y may contain random values or be filled with 0s.

## Examples {#section_tqx_kn2_czb .section}

``` {#codeblock_l5n_ln2_czb}
x = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9]
y = [0, 3, 5, 6, 5, 3, 1, 2, 4, 5]
newx = [0.5, 1.5, 2.5, 3.5, 4.5, 5.5, 6.5, 7.5, 8.5, 9.5]
t=[1,3,5,8]
tck= splrep(x, y, t=t)
print(tck)
// output: ([0,0,0,0,1,3,5,8,9,9,9,9],[0,2.234794827972243,2.999908797063527,8.195517483732592,0.982766102937427,0.416533320193195,6.868465914739519,5,0,0,0,0],3)

newy = splev(newx, tck)
print(newy)
// output: [2.147514374187927,3.928180605155257,5.780093403045226,5.788551610920491,3.842319632145274,1.928386784305488,1.343262026468735,2.600266282317609,5.680148059970901,-0.902321655035049] 
```

Related function: [splrep](splrep.md)

**Parent topic:**[Functions](../../Functions/category.md)

