# spearmanr {#spearmanr}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`spearmanr(X, Y)`

## Arguments {#arguments}

**X** is a vector/ matrix.

**Y** is a vector/ matrix.

## Details {#details}

Calculate the Spearman rank correlation coefficient of *X* and *Y*. Null values are ignored in the calculation. Spearman correlation is a non-parametric measure of the monotonicity of the relationship between two data sets. The coefficient varies between -1 and +1, where 0 means no correlation. -1 or +1 means an exact monotonic relationship.

If *X* or *Y* is a matrix, apply the function to each column and return a vector.

## Examples {#examples}

```
x=[2013.06.13, 2013.06.14, 2013.06.15]
y=1 5 3
spearmanr(x, y)
// output: 0.5

x = [33,21,46,-11,78,47,18,20,-5,66]
y = [1,NULL,10,6,10,3,NULL,NULL,5,3]
spearmanr(x, y)
// output: 0.109109
```

If *X* is a matrix, *Y* can be a vector/matrix with the same number of rows as *X*.

```
m1 = [34,77,35,-40,-39,-86,49,-55,15,72,NULL,-24,16,20,26,-82,80,-93,-65,99,45,90,44,46]$4:6
m2 = [0, 25, 7, 3]
spearmanr(m1, m2)
// output: [0.8, -0.4, 0.5, 0.6, -0.8, 0.4]
```

