# sortBy! {#sortby}

## Syntax {#syntax}

`sortBy!(table, sortColumns, [sortDirections])`

## Arguments {#arguments}

**table** is a table object. It can be a partitioned or unpartitioned in-memory table.

**sortColumns** can be a string scalar/vector indicating the columns based on which the table will be sorted. It can also be a piece of metacode with an expression.

**sortDirections** \(optional\) is a Boolean scalar/vector indicating the sorting directions for the sorting columns. 1 means ascending and 0 means descending. If *sortColumns* is a vector and *sortDirections* is a scalar, the *sortDirections* applies to all the sorting columns.

## Details {#details}

Sort a table in-place based on the specified columns and directions. If the table is a partitioned table, the sorting is conducted within each partition, not on the entire table.

This operation is executed in parallel if the table is a partitioned table and the parallel processing feature is enabled \(when the configuration parameter *localExcutors* &gt; 0\).

## Examples {#examples}

Sort an unpartitioned table:

```
n=20000000
trades=table(rand(`IBM`MSFT`GM`C`YHOO`GOOG,n) as sym, 2000.01.01+rand(365,n) as date, 10.0+rand(2.0,n) as price, rand(1000,n) as qty);
trades.sortBy!(`sym`date, [0,1]);
```

Sort a partitioned table:

```
workDir = "C:/DolphinDB/Data"
if(!exists(workDir)) mkdir(workDir)
trades.saveText(workDir + "/trades.txt")
db = database(workDir + "/trade",VALUE,`IBM`MSFT`GM`C`YHOO`GOOG)
db.loadTextEx("trades","sym", workDir + "/trades.txt")
trades = db.loadTable("trades",`IBM`GM`YHOO,1)
trades.sortBy!(`date)
trades.sortBy!(`date, false)
trades.sortBy!(`date`qty, false)
trades.sortBy!(`date`qty, false true)
trades.sortBy!(<qty*price>)
trades.sortBy!(<[date, sym]>)
trades.sortBy!(<[sym, qty*price]>, true false)
```

