# sort {#sort}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`sort(X, [ascending=true])`

Please refer to [sort!](sort!.md). The only difference between sort and sort! is that the latter assigns the result to X and thus changing the value of X after the execution.

## Arguments {#arguments}

**X** is a vector/matrix.

**ascending** \(optional\) is a Boolean scalar indicating whether to sort *X* in ascending order or descending order. The default value is true \(ascending order\).

## Details {#details}

Return a sorted vector/matrix in ascending/descending order.

## Examples {#examples}

```
x=9 1 5;
x;
// output: [9,1,5]

y=sort(x);
y;
// output: [1,5,9]

sort(x, false);
// output: [9,5,1]

x=1 4 2 5 6 3$2:3;
x;
```

|\#0|\#1|\#2|
|---|---|---|
|1|2|6|
|4|5|3|

```
sort x;
```

|\#0|\#1|\#2|
|---|---|---|
|1|3|5|
|2|4|6|

The `sort!` function change the value of input after sorting.

```
x=9 1 5;
sort!(x);
x;
// output: [1 5 9];
```

Related function: [isort](../i/isort.md)

