# sliceByKey {#slicebykey}

## Syntax {#syntax}

`sliceByKey(table, rowKeys, [colNames], [preserveOrder=false])`

## Arguments {#arguments}

**table** is a keyed table or indexed table.

**rowKeys** is a scalar/vector indicating the specified values of key columns.

**colNames** \(optional\) is a string scalar/vector indicating the names of columns to be selected.

**preserveOrder** \(optional\) is a Boolean scalar indicating whether the result should maintain the input order of *rowKeys*. The default is false, meaning the output may not follow the specified order.

## Details {#details}

Get the rows containing the specified values of the key columns from a keyed table or an indexed table. It is faster than the corresponding SQL statement.

For a keyed table, *rowKeys* must contain values for all key columns.

For an indexed table, *rowKeys* must contain values for the first n key columns.

If *colNames* is not specified, return all columns.

The data form of the result depends on *colNames*. If *colNames* is a scalar, return a vector; if *colNames* is a vector, return an in-memory table.

## Examples {#examples}

```
t = indexedTable(`sym`side, 10000:0, `sym`side`price`qty, [SYMBOL,CHAR,DOUBLE,INT])
insert into t values(`IBM`MSFT`IBM, ['B','S','S'], 125.27 208.9 125.29, 1000 800 200)
a=sliceByKey(t,"IBM", 'price');

a;
// output: [125.27,125.29]

typestr(a);
// output: FAST DOUBLE VECTOR

a=sliceByKey(t,("IBM",'S'));
a;
```

|sym|side|price|qty|
|---|----|-----|---|
|IBM|S|125.29|200|

```
typestr(a);
// output: IN-MEMORY TABLE

t1 = keyedTable(`sym`side, 10000:0, `sym`side`price`qty, [SYMBOL,CHAR,DOUBLE,INT])
insert into t1 values(`IBM`MSFT`IBM, ['B','S','S'], 125.27 208.9 125.29, 1000 800 200)
sliceByKey(t1, [["IBM", "MSFT"], ['B', 'S']]);
```

|sym|side|price|qty|
|---|----|-----|---|
|IBM|B|125.27|1000|
|MSFT|S|208.9|800|

Specify *preserveOrder*=true to return results in the input order of the key columns.

``` {#codeblock_bjb_zdp_mgc}
sliceByKey(table=t1, rowKeys=[["MSFT", "IBM"], ['S', 'B']], preserveOrder=true); 
```

|sym|side|price|qty|
|---|----|-----|---|
|MSFT|S|208.9|800|
|IBM|B|125.27|1000|

