# size {#size}

## Syntax {#syntax}

`size(X)`

## Arguments {#arguments}

**X** is a scalar/vector/matrix/table.

## Details {#details}

For a vector/matrix, `size` returns the number of elements. In comparison, `count` returns the number of non-null elements.

For an in-memory table, `size` returns the number of rows.

## Examples {#examples}

```
size(3 NULL 5 6);
// output: 4

count(3 NULL 5 6);
// output: 3

m=1 2 3 NULL 4 5$2:3;
m;
```

|\#0|\#1|\#2|
|---|---|---|
|1|3|4|
|2||5|

```
size(m);
// output: 6

count(m);
// output: 5

t = table(1 NULL 3 as id, 3 NULL 9 as qty);
t;
```

|id|qty|
|---|---|
|1|3|
|||
|3|9|

```
size(t);
// output: 3

count(t);
// output: 3
```

