# signbit {#signbit}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`signbit(X)`

## Arguments {#arguments}

**X** is a floating-point or integer scalar.

## Details {#details}

Detect the sign bit of the input value.

**Return value**: true if *X* is negative, false otherwise.

## Examples {#examples}

``` {#codeblock_rf2_2xk_21c}
$ signbit('a')
false

$ signbit(-21)
true

$ signbit(-2.1)
true

$ b=complex(10,-5)// create a complex number
$ b
10.0-5.0i
$ signbit(highDouble(b)) // detect the sign bit of the imaginary number
true
$ signbit(lowDouble(b))  // detect the sign bit of the real number
false
```

