# shapiroTest {#shapirotest}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`shapiroTest(X)`

## Arguments {#arguments}

**X** is a numeric vector indicating the sample for the test.

## Details {#details}

Conduct a Shapiro-Wilk test on *X*. Return a dictionary with the following keys:

-   method : "Shapiro-Wilk normality test"

-   pValue : p-value of the test

-   W : W-stat


## Examples {#examples}

```
x = norm(0.0, 1.0, 50)
shapiroTest(x);

/* output:
method->Shapiro-Wilk normality test
pValue->0.621668
W->0.981612
*/
```

