# shape {#shape}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`shape(X)`

## Arguments {#arguments}

**X** is a scalar/vector/matrix/table.

## Details {#details}

Return the dimension of a scalar/vector/matrix as a PAIR.

## Examples {#examples}

Dimension of a scalar is 1 by 1:

```
shape 6;
// output: 1:1

s;
```

Dimension of a vector is the length of the vector by 1:

```
shape 1 5 3 7 8;
// output: 5:1
```

Dimension of a matrix:

```
m=(5 3 1 4 9 10)$3:2;
m;
```

|\#0|\#1|
|---|---|
|5|4|
|3|9|
|1|10|

```
shape m;
// output: 3 :2
```

Dimension of a table:

```
t=table(1 2 3 as x, 4 5 6 as y);
t;
```

|x|y|
|---|---|
|1|4|
|2|5|
|3|6|

```
shape t;
// output: 3 :2
```

