# setTSDBCacheEngineSize {#settsdbcacheenginesize}

## Syntax {#section_dyr_5k2_czb .section}

`setTSDBCacheEngineSize(memSize)`

## Arguments {#section_cyd_vk2_czb .section}

**memSize** is a numeric scalar \(in GB\). It is greater than 0 and less than *maxMemSize* \* 0.75.

## Details {#section_svt_vk2_czb .section}

Modify the capacity of the TSDB cache engine online. In a cluster, this command can only be executed by the admin on the data node or compute node. Please make sure the cache engine is enabled by specifying configuration parameter *TSDBCacheEngineSize* before execution. You can obtain the real-time status of the TSDB cache engine with function `getTSDBCacheEngineSize` to check if the modification takes effect online.

**Note:**

The modified configuration will expire after the cluster is rebooted. To make it permanent, please change the configuration parameter *TSDBCacheEngineSize*.

Since version 2.00.16/3.00.3, when the cache engine memory usage reaches the set value of *TSDBCacheEngineSize*, the system will block the writes. In earlier versions, memory usage could exceed the set value by up to twice under extreme conditions.

For more details, refer to the [*TSDBCacheEngineSize* configuration setting description](../../Database/Configuration/reference.md#).

Related function: [getTSDBCacheEngineSize](../g/getTSDBCacheEngineSize.md).

**Parent topic:**[Functions](../../Functions/category.md)

