# setStreamTableTimestamp {#setStreamTableTimestamp}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#topic_wqp_djk_cbc}

`setStreamTableTimestamp(streamTable, columnName)`

## Arguments {#topic_zjw_2jk_cbc}

**streamTable**can be a regular, shared, persisted or HA stream table.

**columnName**is a string indicating the name of the last column of the table. It must be a time column that records the system time when the message is inserted to the stream table.

## Details {#topic_m1b_fjk_cbc}

Set a time column for the stream table for recording the ingestion time of each message. The system will attach the system time of data ingestion to the column each time data is written. This helps users to measure the delay when writing real-time stream to the stream table.

Note that the column cannot be changed or revoked once set.

## Examples {#topic_xnn_hjk_cbc}

``` {#codeblock_rpb_3jk_cbc}
share streamTable(10000:0,`time`symbol`price`timestamp, [TIMESTAMP,SYMBOL,DOUBLE,TIMESTAMP]) as trades
// set the timestamp column for trades
setStreamTableTimestamp(trades, `timestamp)

// insert a record and the timestamp column is automatically added
insert into trades values(2023.03.19T03:17:49, `A, 10.2)

select * from trades
```

|time|symbol|price|timestamp|
|----|------|-----|---------|
|2023.03.19 03:17:49.000|A|10.2|2024.03.31 08:01:31.324|

